package w83b.ws.aa66;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

import org.apache.commons.lang.StringEscapeUtils;

import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import weblogic.webservice.GenericHandler;
import aa66.ejie.com.RemesaWs;

public class W83bAa66NotificacionesTokenHandler extends GenericHandler{
	
	 HandlerInfo hi;
	 
	 public void init(HandlerInfo info)
	 {
		 hi = info;
    }
	 
	 public QName[] getHeaders() {
	    return hi.getHeaders();
	  }
	  
	 public boolean handleRequest(MessageContext m)  {
		 try {     
			 
		 W83bClsTrazas.traza(null,"W83jsTokenHandler handleRequest");
		 SOAPMessageContext ctx = (SOAPMessageContext) m;
		 SOAPMessage message = ctx.getMessage();
	
		 String sSessionToken = (String)hi.getHandlerConfig().get("sessionToken");
		 RemesaWs remesaWs=null;
		 if(hi.getHandlerConfig().get("remesaWs")!=null){
			 remesaWs=(RemesaWs)hi.getHandlerConfig().get("remesaWs");
		 }
		 
			
			// recuperar cabecera SOAP
			SOAPHeader soapHeader = message.getSOAPPart().getEnvelope().getHeader();
			if (sSessionToken.startsWith("<?xml version=\"1.0\"")) {
				int pos = sSessionToken.indexOf(">") + 1;
				sSessionToken = sSessionToken.substring(pos).trim();
			}
			soapHeader.addTextNode(sSessionToken);
			
			ByteArrayOutputStream myByteArrayOutputString = new ByteArrayOutputStream();
			message.writeTo(myByteArrayOutputString);
			String sSoapMessage = new String(myByteArrayOutputString.toByteArray(), "ISO-8859-15");
			sSoapMessage = processHeaderScape(sSoapMessage);
			if(remesaWs!=null){
				sSoapMessage=this.processBody(sSoapMessage, remesaWs);
			}
			//desescapar caracteres XML
			sSoapMessage=StringEscapeUtils.unescapeXml(sSoapMessage);
			ByteArrayInputStream in = new ByteArrayInputStream(sSoapMessage.getBytes());
			MessageFactory factory = MessageFactory.newInstance();
			message =  factory.createMessage(null, in);
			ctx.setMessage(message);
		 
		} catch (Exception e) { 
			e.printStackTrace(); 
			throw new JAXRPCException(e);
		}    
		return true; 
		
		}
	 
	    
	 	private String processBody(String sSoapMessage, RemesaWs   remesaWs){
	 		String uidPuestoTramitador =remesaWs.getUidPuestoTramitador();
	 		String uidPuestoTramitadorOld =remesaWs.getUidPuestoTramitador();
	 		if(uidPuestoTramitadorOld.length()>10){
	 			uidPuestoTramitadorOld=uidPuestoTramitadorOld.substring(0,10);
	 		}else if(uidPuestoTramitadorOld.length()<7){
	 			StringBuffer uidPuestoTramitadorCompleto= new StringBuffer(uidPuestoTramitadorOld);
				for(int j=0; j<=(7-uidPuestoTramitadorOld.length());j++){
					uidPuestoTramitadorCompleto.append(" ");
				}
				uidPuestoTramitadorOld=uidPuestoTramitadorCompleto.toString();
	 		}
	 		
	 		String result = sSoapMessage.replaceAll(uidPuestoTramitadorOld, uidPuestoTramitador);
	 		if(remesaWs.getListaEnvios()!=null){
		 		String uidPuestoSolicitante =null;
		 		String uidPuestoSolicitanteOld =null;
		 		StringBuffer uidPuestoSolicitanteCompleto= null;
		 		for(int i=0; i<remesaWs.getListaEnvios().length;i++){
		 			uidPuestoSolicitante=remesaWs.getListaEnvios()[i].getUidPuestoSolicitante();
		 			uidPuestoSolicitanteOld=remesaWs.getListaEnvios()[i].getUidPuestoSolicitante();
		 			if(uidPuestoSolicitanteOld.length()>10){
		 				uidPuestoSolicitanteOld=uidPuestoSolicitanteOld.substring(0,10);
		 			}else if(uidPuestoSolicitanteOld.length()<7){
		 				uidPuestoSolicitanteCompleto=new StringBuffer(uidPuestoSolicitanteOld);
		 				for(int j=0; j<=(7-uidPuestoTramitadorOld.length());j++){
		 					uidPuestoSolicitanteCompleto.append(" ");
						}
		 				uidPuestoSolicitante=uidPuestoSolicitanteCompleto.toString();
		 			}
		 		}
		 		result=result.replaceAll(uidPuestoSolicitanteOld, uidPuestoSolicitante);
	 		}
	 		return  result;
	 	}
	 	

	 
		private String processHeaderScape(String sSoapMessage) {
			
			W83bClsTrazas.traza(null,"W83jsTokenHandler processHeaderScape");
			int posEndIni = sSoapMessage.indexOf("Header>") + "Header>".length();

			int posEndEnd = sSoapMessage.indexOf("Header>", posEndIni) + "Header>".length() - 1;
			int posIniEnd = sSoapMessage.lastIndexOf("<", posEndEnd);

			StringBuffer sb = new StringBuffer();
			sb.append(sSoapMessage.substring(0, posEndIni));

			StringBuffer headerContentSb = new StringBuffer();
			String headerContent = sSoapMessage.substring(posEndIni, posIniEnd);
			headerContent = headerContent.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
			headerContentSb.append(headerContent);
			sb.append(headerContentSb);
			sb.append(sSoapMessage.substring(posIniEnd));
		    String ret = sb.toString();

	
			return ret;
		}
		
	 
	 public boolean handleResponse(MessageContext context) {		
		
			
		 return true;
		  
	 }


	 
	 public boolean handleResponse(MessageContext m, String error) {    	
		return true;  
	}
}
